//Spawn Handler
EntityEvents.spawned('minecraft:ender_dragon', event => {
    const {entity} = event
    entity.setAggressive(true)
    entity.setDefaultMovementSpeed(1)
})

EntityEvents.spawned('minecraft:phantom', event => {
    const {entity, level, server} = event
    if (level.dimension != 'minecraft:the_end') return
    let speed = Math.floor(Math.random() *10)
    

    const attributes = [
        ['generic.attack_damage', 4],
        ['generic.attack_knockback', 2],
        ['generic.armor', 6],
        ['generic.armor_toughness', 2],
        ['generic.follow_range', 40],
        ['generic.knockback_resistance', 1.0],
        ['generic.movement_speed', 0.6 + 0.1*speed]]

    attributes.forEach(attributeArr => {
            let attribute = attributeArr[0]
            let value = attributeArr[1]
            entity.setAttributeBaseValue(attribute, value) 
        
    });
    entity.setMaxHealth(30)
    entity.setHealth(30)
    entity.invulnerable = true
    server.scheduleInTicks(40,_ =>{
        entity.invulnerable = false
    })
})

EntityEvents.spawned('minecraft:wither', event => {
    const {entity} = event
    entity.fullNBT.Invulnerable = 0
    entity.persistentData.bufftrigger = 85
    entity.persistentData.id = getRandomInt(1, 1000)
    event.server.runCommandSilent(`team add withered_${entity.persistentData.id}`)
})

EntityEvents.spawned('adventurez:the_eye', event =>{
    const {entity} = event
    entity.fullNBT.Invulnerable = 0
    entity.persistentData.bufftrigger = 90
    const attributes = [
        ['generic.attack_knockback', 10],
        ['generic.follow_range', 2048],
        ['generic.armor', 10],
        ['generic.movement_speed', 0.7]]

    attributes.forEach(attributeArr => {
        let attribute = attributeArr[0]
        let value = attributeArr[1]
        entity.setAttributeBaseValue(attribute, value)
    })
})

EntityEvents.spawned('minecraft:elder_guardian', event => {
    const {entity} = event
    let potion = event.entity.potionEffects
    entity.persistentData.bufftrigger = 100
    potion.add('minecraft:resistance',	999999, 1, false, false) //(MobEffect mobEffect, int duration, int amplifier, boolean ambient, boolean showParticles)
})

EntityEvents.spawned('minecraft:husk', event => {
    const {entity} = event
    let tags = entity.fullNBT?.Tags ?? 'none'
    let nbt = event.entity.fullNBT

    if (tags.toString().includes('pharaoh')){
        //bossbar(entity, 'Pharaoh', 'red', 50);
        //loopHealth(entity)
        entity.persistentData.bufftrigger = 100
        entity.setMaxHealth(80)
        entity.setHealth(80)
        
    }
})

EntityEvents.spawned('adventurez:shaman', event => {
    // summon adventurez:shaman ~ ~ ~ {NoAI:1, Tags:["Boss"]}
    const {entity} = event
    let tags = entity.fullNBT?.Tags ?? 'none'
    let nbt = event.entity.fullNBT
    if (tags.toString().includes('Boss')){
        entity.persistentData.bufftrigger = 100
        //entity.setDefaultMovementSpeed(0.45)
        entity.setMaxHealth(80)
        entity.setHealth(80)
        entity.setAggressive(true)
        giveVanillaGear(event, 'netherite') 

    }
})

EntityEvents.spawned('adventurez:stone_golem', event =>{
    const {entity} = event
    const attributes = [
        ['generic.attack_damage', 10],
        ['generic.attack_knockback', 5],
        ['generic.armor', 10],
        ['generic.armor_toughness', 20],
        ['generic.follow_range', 2048],
        ['generic.knockback_resistance', 1.0],
        ['generic.movement_speed', 0.4]]

    attributes.forEach(attributeArr => {
        let attribute = attributeArr[0]
        let value = attributeArr[1]
        entity.setAttributeBaseValue(attribute, value) 
    })
    blockBreak(event, 5)
})

EntityEvents.spawned('adventurez:soul_reaper', event => {
    let teamname = event.entity.team.name
    if (!teamname.includes('withered_')) return
    giveVanillaGear(event, 'chainmail')
})

EntityEvents.spawned('adventurez:necromancer', event => {
    const {entity, server} = event
    const {x, y, z} = entity
    entity.persistentData.bufftrigger = 85
    server.runCommand(`execute in ${entity.dimension} run summon adventurez:summoner ${x} ${y} ${z}`)
    entity.setMaxHealth(120)
    entity.setHealth(120)
    giveVanillaGear(event, 'netherite') 
})

EntityEvents.spawned('adventurez:summoner', event => {
    const {entity} = event
    entity.persistentData.bufftrigger = 85
    entity.setMaxHealth(80)
    entity.setHealth(80)
    giveVanillaGear(event, 'netherite') 

})

EntityEvents.hurt('adventurez:void_shadow', event => {
    const {entity} = event
    let nbt = entity.fullNBT
    nbt.ShadowIsHalfLife = 1
    entity.fullNBT = nbt
})

EntityEvents.spawned('adventurez:void_fragment', event => {
    const {entity} = event
    let nbt = entity.fullNBT
    nbt.IsVoidOrb = 1
    entity.fullNBT = nbt
})

EntityEvents.hurt("adventurez:void_fragment", event => {    
    const {entity} = event
    let nbt = entity.fullNBT
    nbt.IsVoidOrb = 1
    entity.fullNBT = nbt

})

SummoningRituals.start(event => { 
    const {level, pos, recipe, player} = event
    if (!player) return;
})

//Hurt Handler
EntityEvents.hurt('adventurez:the_eye', event =>{
    const {entity, server, level} = event
    const {x, y, z} = entity

    let bufftrigger = entity.persistentData.bufftrigger;
    let hpPercent = (entity.getHealth()/entity.getMaxHealth()) * 100;
    if (hpPercent > bufftrigger) return
    entity.persistentData.bufftrigger -= 10

    let randamount = getRandomInt(2, 4)  
    let randomx = Math.floor(getRandomInt(-3, 2))
    let randomz = Math.floor(getRandomInt(-3, 2)) 
    for(let i = 0; i < randamount; i++){
        let entity = level.createEntity('adventurez:tiny_eye')
        entity.x = x+randomx
        entity.y = y+1
        entity.z = z+randomz
        entity.spawn()
    }
})

EntityEvents.hurt('adventurez:stone_golem', event =>{
    blockBreak(event, 5)
})

EntityEvents.hurt('minecraft:wither', event => {
    const {entity, server, level} = event
    const {x, y, z} = entity
    let nbt = entity.fullNBT
    let id = entity.persistentData.id
    blockBreak(event, 5)
    let player = event.source.getActual()
    if (player == null) return
    if (!player.isPlayer()) return
    let bufftrigger = entity.persistentData.bufftrigger;
    let hpPercent = (entity.getHealth()/entity.getMaxHealth()) * 100;
    if (hpPercent > bufftrigger) return

    let sec = 20
    let name = player.username
    let dimension = level.getDimension()
    entity.persistentData.bufftrigger -= 20
    actionbar(name, `The Wither's Aura makes you tremble in fear!`)
    let effect = [
        `minecraft:slowness 4 2 false`,
        `minecraft:blindness 4 0 false`
        ]  
    effect.forEach((peffect)=> event.server.runCommandSilent(`execute in ${dimension} run effect give ${name} ${peffect}`))
    
    // Summon Knights and Wither Invulnerable
    server.scheduleInTicks(2*sec,_ => {
        let swordItems = `HandItems:[{id:iron_sword,Count:1},{id:shield,Count:1}]`
        let handItems = `HandItems:[{id:iron_sword,Count:1},{id:shield,Count:1}]`
        let arrowItems = `HandItems:[{id:bow,Count:1},{id:shield,Count:1}]`
        let randamount = getRandomInt(2, 4)  
        let randomx = Math.floor(getRandomInt(-3, 2))
        let randomz = Math.floor(getRandomInt(-3, 2))  
        for(let i = 0; i < randamount; i++){
            if (getRandomInt(0, 1) == 1) handItems = swordItems ?? arrowItems
            let attributes = `${handItems}, CustomName:'[{"text":"Knights of the Wither"}]',Team:withered_${id}, CustomNameVisible:1b,Health:30,Glowing:1b,Tags:[withered],ActiveEffects:[{Id:24,ShowParticles:0b}],HandDropChances:[0.00f,0.00f],ArmorItems:[{id:chainmail_boots,Count:1},{id:chainmail_leggings,Count:1},{id:chainmail_chestplate,Count:1},{id:player_head,tag:{display:{Name:'{"text":"Wither Skull"}'},SkullOwner:{Id:[I;-689328864,-1648275810,-1182795162,1053712544],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWRhOTdjMDZjMDdhMDM1YmQ4NzQ2YjQ4ZDMyZGMwNGU4NDE2MGJkMTYxZjI2YmUxMjcyYjYyNzEyNTFhYWE3In19fQ=="}]}}},Count:1}],ArmorDropChances:[0.00f,0.00f,0.00f,0.00f],Attributes:[{Name:"generic.max_health",Base:30f}]`
            let summon_knight = `execute in ${dimension} run summon adventurez:soul_reaper ${x+randomx} ${y} ${z+randomz} {${handItems},${attributes}}`
            player.getServer().runCommandSilent(summon_knight)             
        }
    entity.invulnerable = true
    })

    // Remove Wither Invulnerable
    server.scheduleInTicks(30*sec,_ =>{
        if (entity.invulnerable) entity.invulnerable = false
    })
})

EntityEvents.hurt('minecraft:elder_guardian', event => {
    const {entity} = event
    const {id, x, y, z} = entity

    let player = event.source.getActual()
    if (player == null) return
    if (!player.isPlayer()) return
    let name = player.username
    if (entity.persistentData?.bufftrigger == undefined) entity.persistentData.bufftrigger = 100
    let potion = entity.potionEffects
    let bufftrigger = entity.persistentData.bufftrigger;
    let hpPercent = (entity.getHealth()/entity.getMaxHealth()) * 100;
    if (hpPercent >= bufftrigger) return
    entity.persistentData.bufftrigger -= 25;
    potion.add('minecraft:regeneration', 10*sec, 1, false, false)
    let command = `execute in overworld run effect give ${name} minecraft:darkness 10 1 false`
    player.tell(`The Elder Guardian enrages and spits Squid ink in your face`)
    player.getServer().runCommandSilent(command)
    for(let i = 0; i < getRandomInt(2, 8); i++){
        let summon = `execute in overworld run summon minecraft:guardian ${x} ${y} ${z}`
        player.getServer().runCommandSilent(summon)
    }
})

EntityEvents.hurt('minecraft:husk', event => {
    const {entity, server} = event
    let tags = entity.fullNBT?.Tags ?? 'none'
    if (!tags.toString().includes('pharaoh')) return
    let player = event.source.getActual()       
    if (!player.isPlayer()) return

    let potion = entity.potionEffects
    let sec = 20

    let bufftrigger = entity.persistentData.bufftrigger;
    let hpPercent = (entity.getHealth()/entity.getMaxHealth()) * 100;
    let revivalTrigger = 50
    if (hpPercent < revivalTrigger){
        let pData = player.persistentData
        
        let heal = `execute as @e[tag=pharaoh] if entity @e[type=minecraft:husk, tag=!pharaoh, distance=..25] run effect give @e[tag=pharaoh] minecraft:instant_damage 10`
        let killhusk = `execute as @e[tag=pharaoh] if entity @e[type=minecraft:husk, tag=!pharaoh, distance=..25] run kill @e[type=minecraft:husk, tag=!pharaoh, limit=1]`
        server.runCommandSilent(heal)
        server.runCommandSilent(killhusk)
        if(pData.pharaohtimer != 0) return
        player.tell(`§2Pharaoh§r: If you want to kill me, kill my minions first!`)
        pData.pharaohtimer = 600

        server.scheduleInTicks(25,_ =>{
            let hpPercent = (entity.getHealth()/entity.getMaxHealth()) * 100;
            if (hpPercent > revivalTrigger) {
                entity.persistentData.bufftrigger = 100
            }
        })
    }
    if (hpPercent > bufftrigger) return
    entity.persistentData.bufftrigger -= 10;
    

})

EntityEvents.hurt('adventurez:shaman', event => {
    const {entity} = event
    const {id, x, y, z} = entity
    let potion = entity.potionEffects
    let sec = 20
    

    let player = event.source.getActual()       
    if (!player.isPlayer()) return
        

    let bufftrigger = entity.persistentData.bufftrigger;
    let hpPercent = (entity.getHealth()/entity.getMaxHealth()) * 100;
    if (hpPercent > bufftrigger) return
    entity.persistentData.bufftrigger -= 10;
    //posbuff Boss
    let randomPosEffect = posEffects[getRandomInt(0, posEffects.length)]
    potion.add(randomPosEffect[0], randomPosEffect[1]*sec, randomPosEffect[2], false, false)

})

EntityEvents.hurt('adventurez:necromancer', event => {
    const {entity, server, level} = event
    const {x, y, z} = entity
    let nbt = entity.fullNBT
    let id = entity.persistentData.id
    let player = event.source.getActual()
    if (!player.isPlayer()) return
    let bufftrigger = entity.persistentData.bufftrigger;
    let hpPercent = (entity.getHealth()/entity.getMaxHealth()) * 100;
    if (hpPercent > bufftrigger) return
    entity.persistentData.bufftrigger -= 25;
    let randamount = getRandomInt(2, 4)  
    let randomx = Math.floor(getRandomInt(-3, 2))
    let randomz = Math.floor(getRandomInt(-3, 2)) 
    for(let i = 0; i < randamount; i++){
        let entity = level.createEntity('adventurez:soul_reaper')
        entity.setMaxHealth(120)
        entity.setHealth(120)
        entity.x = x+randomx
        entity.y = y+1
        entity.z = z+randomz
        entity.spawn()
    }

})

EntityEvents.hurt('adventurez:blaze_guardian', event =>{
    const { source} = event;
    if (!source.player) event.cancel();
    if (source.toString().includes(`'Arrow'`)) event.cancel()
})

EntityEvents.hurt('adventurez:soul_reaper', event => {
    const {entity, server, level} = event
    const {id, x, y, z} = entity
    let teamname = entity?.team?.name
    if (teamname.includes('withered_')){
        blockBreak(event, 3)
    }   
})

//Death Handler
EntityEvents.death('minecraft:wither', event => {
    event.server.runCommandSilent(`team remove withered_${event.entity.persistentData.id}`)
})

EntityEvents.death('adventurez:soul_reaper', event => {
    const {entity, server, level} = event
    const {id, x, y, z} = entity
    let teamname = entity.team.name
    if (teamname.includes('withered_')){
        server.scheduleInTicks(10,_ =>{
        let test = server.runCommand(`execute unless entity @e[team=${teamname}] run execute as @e[type=minecraft:wither,x=${Math.floor(x)}, y=${y}, z=${Math.floor(z)}, distance=..256] run data merge entity @s {Invulnerable:0b}`)
        
        })
    }   
})

EntityEvents.death('minecraft:husk', event => {
    const {entity} = event
    if (!entity.isLiving()) {
		return
	}
    let tags = entity.fullNBT?.Tags ?? "none"

    let player = event.source.getActual()
    if (player == null) return
    if (!player.isPlayer()) return
    if (tags.toString().includes('pharaoh')){
        //Utils.server.runCommandSilent(`bossbar remove minecraft:${entity.id}`)
        if (player.persistentData.cursed == 1){
            title(player.username, "You have lifted the Curse!")
            subtitle(player.username, "you are free now")
        }
        if (player.persistentData.cursed == 0){
            title(player.username, "Cheesing the System!?")
            subtitle(player.username, "The curse has been lifted off the Cursed Eye!")
            actionbar(player.username, "GG on finding this Easter Egg", 'white')  
        }
        player.persistentData.cursed = 2
    }
})